/*
 * Decompiled with CFR 0.152.
 */
package de.cweiske.tools.testsuites;

import de.cweiske.tools.CSVReader;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CSVReaderSuite
extends TestCase {
    CSVReader cr;
    String[][] arData;
    static /* synthetic */ Class class$de$cweiske$tools$testsuites$CSVReaderSuite;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CSVReaderSuite.suite());
    }

    public static Test suite() {
        return new TestSuite(class$de$cweiske$tools$testsuites$CSVReaderSuite == null ? (class$de$cweiske$tools$testsuites$CSVReaderSuite = CSVReaderSuite.class$("de.cweiske.tools.testsuites.CSVReaderSuite")) : class$de$cweiske$tools$testsuites$CSVReaderSuite);
    }

    public void setUp() {
        this.cr = new CSVReader();
    }

    public void testGetChar() {
        this.cr.setData("0123456789abc");
        Assert.assertEquals((char)'0', (char)this.cr.getChar(0));
        Assert.assertEquals((char)'1', (char)this.cr.getChar(1));
        Assert.assertEquals((char)'2', (char)this.cr.getChar(2));
    }

    public void testSimple() {
        this.cr.setSeparator(',');
        this.cr.setData("Name,Event,Date");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Event", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
        this.cr.setSeparator(';');
        this.cr.setData("Name;Event;Date");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Event", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
        this.cr.setSeparator(',');
        this.cr.setData("Name,Event,Date\r\nName2,Event2,Date2\r\n");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)2, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Event", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
        Assert.assertEquals((String)"Name2", (String)this.arData[1][0]);
        Assert.assertEquals((String)"Event2", (String)this.arData[1][1]);
        Assert.assertEquals((String)"Date2", (String)this.arData[1][2]);
    }

    public void testQuotedFields() {
        this.cr.setSeparator(',');
        this.cr.setData("");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)0, (int)this.arData.length);
        this.cr.setSeparator(',');
        this.cr.setData("\"Name\",Event,Date");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Event", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
        this.cr.setSeparator(',');
        this.cr.setData("Name,\"Event\",Date");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Event", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
        this.cr.setSeparator(',');
        this.cr.setData("Name,Event,\"Date\"");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Event", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
        this.cr.setSeparator(',');
        this.cr.setData("\"Name\",\"Event\",\"Date\"");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Event", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
    }

    public void testQuotesInFields() {
        this.cr.setSeparator(',');
        this.cr.setData("\"Na\"\"me\",\"Ev\"\"ent\"\"\",Date");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Na\"me", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Ev\"ent\"", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
    }

    public void testNewLines() {
        this.cr.setSeparator(',');
        this.cr.setData("Name,\"Ev\r\nent\",Date");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Ev\r\nent", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
    }

    public void testSeparator() {
        this.cr.setSeparator(',');
        this.cr.setData("Name,\"Ev,ent\",Date");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Ev,ent", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
    }

    public void testEscapes() {
        this.cr.setSeparator(',');
        this.cr.setData("Na\\r\\nme,Ev\\\"ent,Dat\\\\e");
        this.cr.setAcceptEscapes(true);
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Na\r\nme", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Ev\"ent", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Dat\\e", (String)this.arData[0][2]);
    }

    public void testEmptyFields() {
        this.cr.setSeparator(',');
        this.cr.setData("Name,,Date");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
        this.cr.setSeparator(',');
        this.cr.setData(",,Date");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"", (String)this.arData[0][0]);
        Assert.assertEquals((String)"", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Date", (String)this.arData[0][2]);
        this.cr.setSeparator(',');
        this.cr.setData(",,");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)1, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"", (String)this.arData[0][0]);
        Assert.assertEquals((String)"", (String)this.arData[0][1]);
        Assert.assertEquals((String)"", (String)this.arData[0][2]);
    }

    public void testGuessSeparator() {
        CSVReader cSVReader = new CSVReader();
        cSVReader.setData("Name,Event,Date");
        Assert.assertEquals((char)',', (char)cSVReader.guessSeparator());
        cSVReader.setData("Name;Event;Date");
        Assert.assertEquals((char)';', (char)cSVReader.guessSeparator());
        cSVReader.setData("Name\tEvent\tDate");
        Assert.assertEquals((char)'\t', (char)cSVReader.guessSeparator());
        cSVReader.setData("\"Na;me\",\"Ev;ent\",\"Da;te\"");
        Assert.assertEquals((char)',', (char)cSVReader.guessSeparator());
    }

    public void testExamples() {
        this.cr.setData("Name,Address,Born\r\n\"Smith, Adam\", \"Edinburgh\r\nScotland\", 1723\r\n\"Hobbes, Thomas\", \"Paris\", 1588");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)3, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
        Assert.assertEquals((String)"Name", (String)this.arData[0][0]);
        Assert.assertEquals((String)"Address", (String)this.arData[0][1]);
        Assert.assertEquals((String)"Born", (String)this.arData[0][2]);
        Assert.assertEquals((String)"Smith, Adam", (String)this.arData[1][0]);
        Assert.assertEquals((String)"Edinburgh\r\nScotland", (String)this.arData[1][1]);
        Assert.assertEquals((String)"1723", (String)this.arData[1][2]);
        Assert.assertEquals((String)"Hobbes, Thomas", (String)this.arData[2][0]);
        Assert.assertEquals((String)"Paris", (String)this.arData[2][1]);
        Assert.assertEquals((String)"1588", (String)this.arData[2][2]);
    }

    public void testLineCount() {
        this.cr.setData("Line1\nLine2\nLine3\nLine4");
        this.arData = this.cr.parseData(0);
        Assert.assertEquals((int)4, (int)this.arData.length);
        this.arData = this.cr.parseData(1);
        Assert.assertEquals((int)1, (int)this.arData.length);
        this.arData = this.cr.parseData(2);
        Assert.assertEquals((int)2, (int)this.arData.length);
        this.arData = this.cr.parseData(3);
        Assert.assertEquals((int)3, (int)this.arData.length);
        this.arData = this.cr.parseData(4);
        Assert.assertEquals((int)4, (int)this.arData.length);
        this.arData = this.cr.parseData(5);
        Assert.assertEquals((int)4, (int)this.arData.length);
    }

    public void testCorruptedCSV() {
        this.cr.setSeparator(',');
        this.cr.setData("Line1Col1\r\nLine2Col1,Line2Col2\r\nLine3Col1,Line3Col2,Line3Col3");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)3, (int)this.arData.length);
        Assert.assertEquals((int)1, (int)this.arData[0].length);
        this.cr.setSeparator(',');
        this.cr.setData("Line1Col1,Line1Col2,Line1Col3\r\nLine2Col1,Line2Col2\r\nLine3Col1");
        this.arData = this.cr.parseData();
        Assert.assertEquals((int)3, (int)this.arData.length);
        Assert.assertEquals((int)3, (int)this.arData[0].length);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

