<?php
/**
* Kernelmap
* makes a tree-like representation of all the kernel config options
*
* @author Christian Weiske <cweiske@cweiske.de>
*/
$strKernelSourcePath	= '/usr/src/linux/';


function mapIt( $strBaseFile)
{
	global $strKernelSourcePath;
    
	$strContents	= file_get_contents( $strBaseFile);
	$arContents		= explode( "\n", $strContents);
    $arStack		= array();
    $strFuncName	= null;
    $strFuncId		= null;
    while( count( $arContents) > 0) 
    {
		//Line by line until we have a nice char at the beginning
        foreach( $arContents as $nId => $strLine)
        {
        	unset( $arContents[$nId]);
        	if( trim( $strLine[0]) == $strLine[0]) 
            {
            	//we've got something here...
                break;
            } else {
            	//normal stuff like description or type
                $strLine	= trim( $strLine);
                $strFirstWord	= substr( $strLine, 0, strpos( $strLine, ' '));
                if( $strFirstWord == 'tristate' || $strFirstWord == 'bool' 
                 || $strFirstWord == 'prompt' || $strFirstWord == 'int'
                 || $strFirstWord == 'hex')
                {
                	$strFuncName	= substr( $strLine, strlen( $strFirstWord) + 2, -1);
//                    echo $strFuncName . "|";
                }//name
            }
        }//foreach $arContents
        
        if( $strFuncName != null || $strFuncId != null) 
        {
        	//we're at the end of something, so print it out
            echo str_pad( '', count( $arStack), "\t") . $strFuncId . " - " . $strFuncName . "\r\n";
            $strFuncName	= null;
            $strFuncId		= null;
        }
        
        //check what's up
        $strFirstWord	= trim( substr( $strLine, 0, strpos( $strLine, ' ') > 0 ? strpos( $strLine, ' ') : 100));
//        echo $strFirstWord . ":" . "\r\n";
        if( $strFirstWord == 'config') {
        	$strFuncId	= substr( $strLine, strlen( $strFirstWord) + 1);
        } else if( $strFirstWord == 'menu' || $strFirstWord == 'mainmenu') {
        	//we're waiting for this
        	$strMenuName	= substr( $strLine, strlen( $strFirstWord) + 2, -1);
			echo str_pad( '', count( $arStack), "\t") . $strMenuName . " >>>\r\n";
            $arStack[ count( $arStack)]	= 'end' . $strFirstWord;
        } else if( $strFirstWord == $arStack[ count( $arStack) - 1]) {
        	//we're at the end of something... pop it off
            unset( $arStack[ count( $arStack) -1]);
        } else if( $strFirstWord == 'source') {
        	$strBaseFile	= $strKernelSourcePath . substr( $strLine, 8, -1);
//            echo $strBaseFile . "\r\n";
            $strContents	= file_get_contents( $strBaseFile);
            $arContents2	= explode( "\n", $strContents);
            $arContents		= array_merge( $arContents2, $arContents);
            unset( $arContents2);
        }
        
        
    }//while nCounter
}//function mapIt( $strBaseFile)

//start it for the i386 computers...
mapIt( $strKernelSourcePath . 'arch/i386/Kconfig');


?>