<?php
	/////////////////////////////
	//        XML class        //
	//   by Christian Weiske   //
	//    cweiske@cweiske.de   //
	//						   //
	// last change: 2003-05-09 //
	/////////////////////////////

/**
*	Example:
*		$xmlFile = new XMLFile( "file.xml");
*		$xmlFile->Load();
*		print_r( $xmlFile->XMLObject);
*	-> now you've got the XML tree as the $XMLObject
*		$xmlFile->XMLObject->root->newnode->Value = "test";
*		$xmlFile->Obj2XML();
*		echo $xmlFile->strXMLObject;
*	-> now the new XML file is in $strXMLObject
*		$xmlFile->Save( "output.xml");
*	-> all data stored in output.xml
*
**************************************************************************
*	class XMLFile
*		function XMLFile( $strXMLfile = "")
*		function Load()
*		function _LoadData( $arXMLTags, $nID, $XMLObject, $strParentTag)
*		function MakeArray( &$objParent, $strObject)
*		function _DisplayError( $strError)
*		function Obj2XML()
*		function _Obj2XMLBlocks( $objObject, $nLevel = 0, $strParent = "") 
*		function Save( $strSaveFile = NULL)
*
*	changelog
*	[2003-05-09]
*	- recognizes "0" as value now (fucking "empty" function)
*
*/

class XMLFile
{
	var $bDispErrors = false;	//Shall Errors be printed out?
	var $strXMLfile;		//Filename
	var $strXMLtext;		//Data from file
	var $arParsedTags;		
	var $bLoaded = false;
	var $XMLObject;			//contains XML-Tree as Object
	var $strXMLObject;		//Obj2XML Output

	//konstruktor
	function XMLFile( $strXMLfile = "")
	{
		if( isset( $strXMLfile))
			$this->strXMLfile = $strXMLfile;
	}//function XMLFile( $strXMLfile = "")

	function Load()
	{
		$str_xmlData = "";
		$arXMLTags = array();
		$arXMLIndex = array();

		$arParsedTags = array();

		//if text not already there, load from the file
		if( $this->strXMLtext == "") {
			$this->_LoadFile();
		}

		$xml_parser = xml_parser_create();
		xml_parse_into_struct( $xml_parser, $this->strXMLtext, $arXMLTags, $arXMLIndex);
		if( xml_get_error_code( $xml_parser) != XML_ERROR_NONE)	{
			$this->_DisplayError( "Load(): XML Error: " . xml_get_error_code( $xml_parser) . ": " . xml_error_string( xml_get_error_code( $xml_parser)));
			return false;
		}
		xml_parser_free( $xml_parser);

		$nID	= -1;
		$this->_LoadData( $arXMLTags, $nID, $this->XMLObject, strtolower( $arXMLTags[0]["tag"]));

		$bLoaded = true;

		return $this->XMLObject;
	}//function Load()




	function _LoadFile()
	{
		if( !isset( $this->strXMLfile) || !file_exists( $this->strXMLfile))
		{
			$this->_DisplayError( "Load(): File \"$this->strXMLfile\" doesn't exist");
			return false;
		}

		$filehandle		= fopen( $this->strXMLfile, "r");
		$str_xmlData	= "";

		while( !feof( $filehandle))
		{
			$str_xmlData .= fgets( $filehandle, 8192);
		}
		fclose( $filehandle);
		
		$this->strXMLtext = $str_xmlData;
	}//function _LoadFile()



	
	
	function _LoadData( &$arXMLTags, &$nID, &$XMLObject, $strParentTag)
	{
		do
		{
			$nID++;
			$strName = strtolower( $arXMLTags[$nID]["tag"]);
			$strType = strtolower( $arXMLTags[$nID]["type"]);

			if( $strType == "close")
				return;

			if( !( $strName == $strParentTag && $strType == "cdata") )
			{

				//existiert noch nicht
				if( !isset( $XMLObject->$strName) )
				{
					$newObject = &$XMLObject->$strName;
					$newObject = "";
				}
				//Mehrfach vorhanden, aber noch kein array -> array machen
				elseif( ($strType == "open" || $strType == "complete") && isset( $XMLObject->$strName) && !is_array( $XMLObject->$strName))
				{
					$temp = $XMLObject->$strName;
					unset( $XMLObject->$strName);
					$tmpObj = &$XMLObject->$strName;
					$tmpObj[0] = $temp;
					$newObject = &$tmpObj[1];
				}
				elseif( $strType == "open" || $strType == "complete")
				{
					$tmpObj = &$XMLObject->$strName;
					$newObject = &$tmpObj[ sizeof( $XMLObject->$strName)];
				}
				else
				{
					$newObject = &$XMLObject;
				}
				//Wenn Attrib. vorhanden, Unterobjekt "Attributes" erstellen und dort Attribute sammeln
				if( isset( $arXMLTags[$nID]["attributes"] ) &&is_array( $arXMLTags[$nID]["attributes"]))
				{
					foreach( $arXMLTags[$nID]["attributes"] as $strAttributeName => $strAttributeValue)
					{
						$strAttributeName = strtolower( $strAttributeName);
						$newObject->Attributes->$strAttributeName = $strAttributeValue;
					}
				}

				switch( $strType)
				{
					case "open":
						$this->_LoadData( $arXMLTags, $nID, $newObject, $strName);
						break;
					case "complete":
						if( isset( $arXMLTags[$nID]["value"]) && $arXMLTags[$nID]["value"] != "")
							$newObject->Value = $arXMLTags[$nID]["value"];
						break;
					case "close":
						return;
						break;
				}
			}//keine Parent-Tag-Wiederholung
		}
		while( $nID < sizeof( $arXMLTags) - 1);

		return;
	}//function LoadData( $arXMLTags, $nID, $XMLObject, $strParentTag)


	/*
	*	Convert an node to an array
	*	Useful if you exspect an array
	*/
	function MakeArray( &$objParent, $strObject)
	{
		if( is_array( $objParent->$strObject))
			return $objParent->$strObject;


		$temp = $objParent->$strObject;
		unset( $objParent->$strObject);
		$tmpObj = &$objParent->$strObject;
		$tmpObj[0] = $temp;

		return $objParent->$strObject;
	}//function MakeArray( &$objParent, $strObject)



	function _DisplayError( $strError)
	{
		if( $this->bDispErrors) {
			echo "<b>Error</b> in class XMLFile:<br />" . $strError;
		}
	}//function DisplayError( $strError)



	function Obj2XML()
	{
		$strXMLFile = "<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?" . ">\n";
		$strXMLFile .= $this->_Obj2XMLBlocks( $this->XMLObject);
		$this->strXMLObject = $strXMLFile;
	}

	function _Obj2XMLBlocks( $objObject, $nLevel = 0, $strParent = "") 
	{
		$nIndent = 3;
		$strXML = "";
		if( !is_object($objObject) && !is_array( $objObject)) {
			return;
		}
		foreach( $objObject as $strObjName => $objSub)
		{
			if( is_array( $objObject)) {
				$strObjName = $strParent;
			}
			if( $strObjName != "Attributes" && $strObjName != "Value")
			{
				$strXMLTeil = str_repeat( " ", $nLevel * $nIndent) . "<" . $strObjName;
				$strAttributes = "";
				if( isset( $objSub->Attributes))
				{
					foreach( $objSub->Attributes as $strAttribute => $strAttributeValue)
					{
						$strAttributes .= " " . $strAttribute . "=\"" . $strAttributeValue . "\"";
					}
				}
				$strXMLTeil .= $strAttributes;
				$nSubs = count( $objSub);//doesn't work, don't know why	-> because count is only for arrays?
				$nSubs = 0;
				if( is_object( $objSub) || is_array( $objSub)) {
					foreach( $objSub as $strT => $obj) {
						$nSubs++;
					}
					if( isset( $objSub->Value)) {
						$nSubs--;
					}
					if( isset( $objSub->Attributes)) {
						$nSubs--;
					}
					if( !is_object( $objSub) && !is_array( $objSub)) {
						$nSubs = 0;
					}
				}
				if( $nSubs < 1) {
					if( isset( $objSub->Value) && strlen( $objSub->Value) > 0) {
						$strXMLTeil .= ">" . htmlspecialchars( $objSub->Value) . "</" . $strObjName . ">\n";
					} else {
						$strXMLTeil .= " />\n";
					}
					$strXML .= $strXMLTeil;
				} 
				//das Ding hat andere Objekte drunter
				else 
				{
					$strXMLTeil .= ">\n";

					if( is_array( $objSub)) {
						$nNewLevel = $nLevel;
					} else {
						$nNewLevel = $nLevel + 1;
					}
					$strXMLSub = $this->_Obj2XMLBlocks( $objSub, $nNewLevel, $strObjName);
					$strXMLTeil .= $strXMLSub;
					$strXMLTeil .= str_repeat( " ", $nLevel * $nIndent) . "</" . $strObjName . ">\n";

					if( !is_array( $objSub)) {
						$strXML .= $strXMLTeil;
					} else {
						$strXML .= $strXMLSub;
					}
				}
			}//if( $strObjName != "Attributes" && $strObjName != "Value")
		}//foreach in obj

		return $strXML;
	}//function _Obj2XMLBlocks( $objObject, $nLevel = 0, $strParent = "") 

	
	//Saves the strXMLObject in the file strXMLfile
	function Save( $strSaveFile = NULL)
	{
		global
			$php_errormsg;

		if( empty( $this->strXMLObject)) {
			return false;
		}
		if( $strSaveFile == NULL) {
			$strSaveFile = $this->strXMLfile;
		}

		$fp = @fopen( $strSaveFile, "w") or false;
		if( $fp === false) {
			$this->_DisplayError( "Save(): Couldn't open output file \"" . $this->strXMLSaveFile . "\"<br />\n" . $php_errormsg);
		} else {
			fwrite( $fp, $this->strXMLObject);
			fclose( $fp);
		} 

		return true;
	}//function Save( $strSaveFile = NULL)

}//class XMLFile

?>